
import gurobipy as gp

# Create a new model
model = gp.Model("LeatherShop")

# Define variables
x1 = model.addVar(name="wallets", lb=0, vtype=gp.GRB.INTEGER)  # Number of wallets
x2 = model.addVar(name="purses", lb=0, vtype=gp.GRB.INTEGER)   # Number of purses

# Objective function: Maximize profit
model.setObjective(50*x1 + 100*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(10*x1 + 15*x2 <= 500, name="cutting_time")
model.addConstr(20*x1 + 30*x2 <= 600, name="stitching_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.getVarByName('wallets').varName} = {model.getVarByName('wallets').x}, {model.getVarByName('purses').varName} = {model.getVarByName('purses').x}")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found")
