
import gurobipy as gp

# Create a new model
m = gp.Model("toy_production")

# Create variables
plush_toys = m.addVar(vtype=gp.GRB.CONTINUOUS, name="plush_toys")
action_figures = m.addVar(vtype=gp.GRB.CONTINUOUS, name="action_figures")


# Set objective function
m.setObjective(4 * plush_toys + 4.5 * action_figures, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * plush_toys + 15 * action_figures <= 1200, "assembly_time")
m.addConstr(4 * plush_toys + 5 * action_figures <= 900, "packaging_time")
m.addConstr(plush_toys >= 0, "plush_toys_nonnegative")  # Ensure non-negative values
m.addConstr(action_figures >= 0, "action_figures_nonnegative") # Ensure non-negative values

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of plush toys: {plush_toys.x}")
    print(f"Number of action figures: {action_figures.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

