
from gurobipy import *

# Create a new model
m = Model("ToyShop")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="plush_toys", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="action_figures", lb=0)

# Set the objective function
m.setObjective(4*x1 + 4.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 1200, "assembly_time")
m.addConstr(4*x1 + 5*x2 <= 900, "packaging_time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Plush toys: {x1.x}")
    print(f"Action figures: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
