
import gurobi

def solve_toy_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="plush_toys", lb=0, ub=None, obj=4)
    x2 = model.addVar(name="action_figures", lb=0, ub=None, obj=4.50)

    # Add constraints
    model.addConstr(20*x1 + 15*x2 <= 1200, name="assembly_time")
    model.addConstr(4*x1 + 5*x2 <= 900, name="packaging_time")

    # Set the objective function
    model.setObjective(x1.obj * x1.varName + x2.obj * x2.varName, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of plush toys: {x1.x}")
        print(f"Number of action figures: {x2.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_toy_shop_problem()
