
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("jewelry_optimization")

# Create variables
rings = m.addVar(vtype=GRB.INTEGER, name="rings")
necklaces = m.addVar(vtype=GRB.INTEGER, name="necklaces")

# Set objective function
m.setObjective(50 * rings + 75 * necklaces, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * rings + 3 * necklaces <= 1000, "gold_constraint")
m.addConstr(rings >= 3 * necklaces, "popularity_constraint")
m.addConstr(necklaces >= 50, "minimum_necklaces_constraint")
m.addConstr(rings >=0, "non_negativity_rings")
m.addConstr(necklaces >=0, "non_negativity_necklaces")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of rings: {rings.x}")
    print(f"Number of necklaces: {necklaces.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

