
from gurobipy import *

# Create a model
m = Model("Jeweler_Profit")

# Define variables
x1 = m.addVar(name='number_of_rings', vtype=GRB.INTEGER)
x2 = m.addVar(name='number_of_necklaces', vtype=GRB.INTEGER)

# Set objective function
m.setObjective(50*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 <= 1000, name='gold_constraint')
m.addConstr(x1 >= 3*x2, name='ring_necklace_ratio')
m.addConstr(x2 >= 50, name='minimum_necklaces')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
