
import gurobi

def solve_jewelry_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="rings", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of rings
    x2 = model.addVar(name="necklaces", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of necklaces

    # Objective function: Maximize 50*x1 + 75*x2
    model.setObjective(50*x1 + 75*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 3*x2 <= 1000, name="gold_constraint")
    model.addConstr(x1 - 3*x2 >= 0, name="ratio_constraint")
    model.addConstr(x2 >= 50, name="necklaces_min_constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: rings = {x1.varValue}, necklaces = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_jewelry_problem()
