
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("woodshop")

# Create variables
tables = m.addVar(vtype=GRB.CONTINUOUS, name="tables")
desks = m.addVar(vtype=GRB.CONTINUOUS, name="desks")

# Set objective function
m.setObjective(350 * tables + 400 * desks, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * tables + 3 * desks <= 100, "woodworking")
m.addConstr(3 * tables + 4 * desks <= 75, "nails")
m.addConstr(1 * tables + 2 * desks <= 80, "varnish")
m.addConstr(tables >=0)
m.addConstr(desks >= 0)


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Dining Tables: {tables.x}")
    print(f"  Desks: {desks.x}")
    print(f"  Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

