
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='dining_tables', lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name='desks', lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(350 * x1 + 400 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * x1 + 3 * x2 <= 100, name='woodworking_constraint')
    model.addConstr(3 * x1 + 4 * x2 <= 75, name='nails_constraint')
    model.addConstr(x1 + 2 * x2 <= 80, name='varnish_constraint')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
