
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pancakes_and_tea")

# Create variables
tea = m.addVar(vtype=GRB.CONTINUOUS, name="tea")  # Pitchers of green tea
pancakes = m.addVar(vtype=GRB.CONTINUOUS, name="pancakes")  # Batches of pancakes

# Set objective function
m.setObjective(2.5 * tea + 10 * pancakes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7 * tea + 1.2 * pancakes <= 8, "Joy's time")
m.addConstr(0.3 * tea + 0.6 * pancakes <= 5, "Willa's time")
m.addConstr(tea >= 0, "Non-negative tea")  # Ensure non-negative values
m.addConstr(pancakes >= 0, "Non-negative pancakes") # Ensure non-negative values


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Pitchers of green tea: {tea.x:.2f}")
    print(f"Batches of pancakes: {pancakes.x:.2f}")

