
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="green_tea_pitchers")
    x2 = model.addVar(lb=0, name="pancake_batches")

    # Define the objective function
    model.setObjective(2.5 * x1 + 10 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(0.7 * x1 + 1.2 * x2 <= 8, name="joy_time_constraint")
    model.addConstr(0.3 * x1 + 0.6 * x2 <= 5, name="willa_time_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of pitchers of green tea: {x1.varValue}")
        print(f"Number of batches of pancakes: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
