
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("car_production")

# Create variables
y1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="y1") # Number of hybrid cars
y2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="y2") # Number of electric cars


# Set objective function
m.setObjective(4500 * y1 + 5500 * y2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(y1 <= 9, "hybrid_demand")
m.addConstr(y2 <= 5, "electric_demand")
m.addConstr(y1 + y2 <= 10, "total_production")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of hybrid cars to produce: {y1.x}")
    print(f"Number of electric cars to produce: {y2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

