
import gurobi

def solve_eta_auto_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    y1 = model.addVar(lb=0, name="hybrid_models")
    y2 = model.addVar(lb=0, name="electric_models")

    # Objective function: Maximize 4500*y1 + 5500*y2
    model.setObjective(4500 * y1 + 5500 * y2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(y1 <= 9, name="hybrid_demand_constraint")
    model.addConstr(y2 <= 5, name="electric_demand_constraint")
    model.addConstr(y1 + y2 <= 10, name="total_cars_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {y1.varName} = {y1.x}, {y2.varName} = {y2.x}")
    else:
        print("No optimal solution found")

solve_eta_auto_problem()
