
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CE_Chemicals")

# Create variables
adhesives = m.addVar(vtype=GRB.CONTINUOUS, name="adhesives")  # Packages of adhesives
plasticizers = m.addVar(vtype=GRB.CONTINUOUS, name="plasticizers")  # Packages of plasticizers


# Set objective function
m.setObjective(8.5 * adhesives + 11.5 * plasticizers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * adhesives + 8 * plasticizers <= 450, "Automatic Device Constraint")
m.addConstr(5 * adhesives + 4 * plasticizers <= 450, "Human-Operated Device Constraint")
m.addConstr(adhesives >= 0, "Non-negativity constraint for adhesives")
m.addConstr(plasticizers >= 0, "Non-negativity constraint for plasticizers")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal:.2f}")
    print(f"Packages of Adhesives: {adhesives.x:.2f}")
    print(f"Packages of Plasticizers: {plasticizers.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

