
import gurobipy as gp

# Create a new model
model = gp.Model("CE_Chemicals_Production")

# Define variables
x1 = model.addVar(name="adhesives", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="plasticizers", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: maximize revenue
model.setObjective(8.5 * x1 + 11.5 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(6 * x1 + 8 * x2 <= 450, name="automatic_device_constraint")
model.addConstr(5 * x1 + 4 * x2 <= 450, name="human_operated_device_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Packages of adhesives to produce: {x1.varValue}")
    print(f"Packages of plasticizers to produce: {x2.varValue}")
    print(f"Max revenue: {model.objVal}")
else:
    print("No optimal solution found.")
