
import gurobipy as gp

# Create a new model
m = gp.Model("shoe_profit")

# Create variables
sneakers = m.addVar(vtype=gp.GRB.INTEGER, name="sneakers")
boots = m.addVar(vtype=gp.GRB.INTEGER, name="boots")

# Set objective function
m.setObjective(50 * sneakers + 80 * boots, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(sneakers + boots <= 50, "demand")
m.addConstr(150 * sneakers + 200 * boots <= 8750, "budget")
m.addConstr(sneakers >= 0, "sneakers_non_negative")  # Explicit non-negativity constraints
m.addConstr(boots >= 0, "boots_non_negative")  # Explicit non-negativity constraints


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of sneakers to buy: {sneakers.x}")
    print(f"Number of boots to buy: {boots.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

