
from gurobipy import *

# Create a new model
model = Model("George_Shoes_Problem")

# Add variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="sneakers", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="boots", lb=0)

# Set the objective function
model.setObjective(50*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 50, "demand_limit")
model.addConstr(150*x1 + 200*x2 <= 8750, "budget_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of sneakers: {x1.x}")
    print(f"Number of boots: {x2.x}")
    print(f"Total profit: ${50*x1.x + 80*x2.x:.2f}")
else:
    print("No optimal solution found")
