
import gurobipy as gp

def solve_george_problem():
    # Create a new model
    model = gp.Model("George's Problem")

    # Define variables
    x1 = model.addVar(name="sneakers", lb=0, ub=50, vtype=gp.GRB.INTEGER)
    x2 = model.addVar(name="boots", lb=0, ub=50, vtype=gp.GRB.INTEGER)

    # Objective function: Maximize 50*x1 + 80*x2
    model.setObjective(50*x1 + 80*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 <= 50, name="demand_sneakers")
    model.addConstr(x2 <= 50, name="demand_boots")
    model.addConstr(150*x1 + 200*x2 <= 8750, name="budget_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: Buy {x1.varValue} sneakers and {x2.varValue} boots.")
    else:
        print("No optimal solution found.")

solve_george_problem()
