
import gurobipy as gp

# Create a new model
m = gp.Model("cookie_production")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chocolate_chip_cookies") # batches of chocolate chip cookies
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oatmeal_cookies") # batches of oatmeal cookies


# Set objective function
m.setObjective(12*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 8*x2 <= 1000, "ingredient_gathering")
m.addConstr(20*x1 + 15*x2 <= 1200, "mixing")
m.addConstr(50*x1 + 30*x2 <= 3000, "baking")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Batches of chocolate chip cookies: {x1.x:.2f}")
    print(f"Batches of oatmeal cookies: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

