
from gurobipy import *

# Create a new model
m = Model("Cookie_Profit_Maximization")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chocolate_chip_batches", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="oatmeal_batches", lb=0)

# Set the objective function to maximize profit
m.setObjective(12*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints based on time availability
m.addConstr(10*x1 + 8*x2 <= 1000, "ingredient_gathering_time")
m.addConstr(20*x1 + 15*x2 <= 1200, "mixing_time")
m.addConstr(50*x1 + 30*x2 <= 3000, "baking_time")

# Optimize the model
m.optimize()

# Print the results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal batches of chocolate chip cookies:", x1.x)
    print("Optimal batches of oatmeal cookies:", x2.x)
    print("Maximum profit: $", m.objVal)
else:
    print("No optimal solution found.")
