
import gurobipy as gp

# Create a new model
model = gp.Model("Cookie Production")

# Define variables
x1 = model.addVar(name="chocolate_chip", lb=0, vtype=gp.GRB.INTEGER)  # batches of chocolate chip cookies
x2 = model.addVar(name="oatmeal", lb=0, vtype=gp.GRB.INTEGER)  # batches of oatmeal cookies

# Objective function: Maximize profit
model.setObjective(12 * x1 + 15 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(10 * x1 + 8 * x2 <= 1000, name="gathering_ingredients")
model.addConstr(20 * x1 + 15 * x2 <= 1200, name="mixing")
model.addConstr(50 * x1 + 30 * x2 <= 3000, name="baking")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal batches of chocolate chip cookies: {x1.varValue}")
    print(f"Optimal batches of oatmeal cookies: {x2.varValue}")
    print(f"Maximal profit: ${model.objVal}")
else:
    print("The model is infeasible.")
