
import gurobipy as gp

# Create a new model
m = gp.Model("Medication Mixing")

# Create variables
x1 = m.addVar(lb=0, name="medication_A")  # Units of medication A
x2 = m.addVar(lb=0, name="medication_B")  # Units of medication B

# Set objective function
m.setObjective(1*x1 + 2*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x1 + 3*x2 >= 20, "cough_relief")
m.addConstr(2*x1 + 1*x2 >= 25, "pain_relief")
m.addConstr(3*x1 + 2*x2 >= 30, "fever_relief")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Medication A: {x1.x} units")
    print(f"Medication B: {x2.x} units")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

