
from gurobipy import *

# Create a new model
m = Model("Medication_Mix")

# Add variables to the model
x1 = m.addVar(name="med_A", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="med_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 >= 20, name="cough_relief")
m.addConstr(2*x1 + x2 >= 25, name="pain_relief")
m.addConstr(3*x1 + 2*x2 >= 30, name="fever_relief")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Medication A:", x1.x)
    print("Medication B:", x2.x)
    print("Total Cost:", m.objVal)
else:
    print("No optimal solution found.")
