
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="medication_A")
x2 = model.addVar(lb=0, name="medication_B")

# Define the objective function
model.setObjective(x1 + 2*x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(x1 + 3*x2 >= 20, name="cough_relief")
model.addConstr(2*x1 + x2 >= 25, name="pain_relief")
model.addConstr(3*x1 + 2*x2 >= 30, name="fever_relief")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Medication A: {x1.varValue}")
    print(f"Medication B: {x2.varValue}")
    print(f"Total Cost: {model.objVal}")
else:
    print("No optimal solution found.")
