
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Jacket Production")

# Create variables
winter_jackets = m.addVar(vtype=GRB.INTEGER, name="winter_jackets")
rain_jackets = m.addVar(vtype=GRB.INTEGER, name="rain_jackets")

# Set objective function
m.setObjective(-5 * winter_jackets + 50 * rain_jackets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(winter_jackets <= 60, "Winter Jacket Capacity")
m.addConstr(rain_jackets <= 70, "Rain Jacket Capacity")
m.addConstr(winter_jackets >= 30, "Winter Jacket Demand")
m.addConstr(rain_jackets >= 35, "Rain Jacket Demand")
m.addConstr(winter_jackets + rain_jackets >= 80, "Total Jacket Contract")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of winter jackets to produce: {winter_jackets.x}")
    print(f"Number of rain jackets to produce: {rain_jackets.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

