
from gurobipy import *

# Create a new model
m = Model("Jacket_Production")

# Define variables
x1 = m.addVar(lb=30, ub=60, vtype=GRB.INTEGER, name="winter_jackets")
x2 = m.addVar(lb=35, ub=70, vtype=GRB.INTEGER, name="rain_jackets")

# Set the objective function
m.setObjective(-5*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 60, "max_winter_jackets")
m.addConstr(x2 <= 70, "max_rain_jackets")
m.addConstr(x1 >= 30, "min_winter_jackets")
m.addConstr(x2 >= 35, "min_rain_jackets")
m.addConstr(x1 + x2 >= 80, "total_jackets")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Winter jackets: {x1.x}")
    print(f"Rain jackets: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
