
import gurobi

def solve_jacket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=60, name="winter_jackets")
    x2 = model.addVar(lb=0, ub=70, name="rain_jackets")

    # Objective function: Maximize 50*x2 - 5*x1
    model.setObjective(50*x2 - 5*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 30, name="min_winter_jackets")
    model.addConstr(x2 >= 35, name="min_rain_jackets")
    model.addConstr(x1 + x2 >= 80, name="total_jackets")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of winter jackets: {x1.varValue}")
        print(f"Number of rain jackets: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_jacket_problem()
