
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
healthcare_investment = m.addVar(name="healthcare_investment")
energy_investment = m.addVar(name="energy_investment")

# Set objective function
m.setObjective(0.04 * healthcare_investment + 0.08 * energy_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(healthcare_investment + energy_investment <= 500000, "total_investment")
m.addConstr(healthcare_investment >= 0.6 * (healthcare_investment + energy_investment), "healthcare_min")
m.addConstr(energy_investment <= 0.35 * (healthcare_investment + energy_investment), "energy_max")
m.addConstr(healthcare_investment >= 0, "healthcare_nonnegative")
m.addConstr(energy_investment >= 0, "energy_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in healthcare: {healthcare_investment.x}")
    print(f"Optimal investment in energy: {energy_investment.x}")
    print(f"Maximum return: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

