
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="healthcare_investment")
x2 = m.addVar(lb=0, name="energy_investment")

# Set the objective function
m.setObjective(0.04*x1 + 0.08*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500000, "total_investment")
m.addConstr(x1 >= 300000, "healthcare_minimum")
m.addConstr(x2 <= 175000, "energy_maximum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Healthcare Investment: {x1.x}")
    print(f"Energy Investment: {x2.x}")
    print(f"Total Return: {0.04*x1.x + 0.08*x2.x}")
else:
    print("No optimal solution found")
