
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="healthcare_investment", lb=0)
    x2 = model.addVar(name="energy_sector_investment", lb=0)

    # Objective function: Maximize 0.04*x1 + 0.08*x2
    model.setObjective(0.04 * x1 + 0.08 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500000)
    model.addConstr(x1 >= 0.6 * 500000)
    model.addConstr(x2 <= 0.35 * 500000)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in healthcare: $", x1.varValue)
        print("Optimal investment in energy sector: $", x2.varValue)
        print("Maximum return: ", 0.04 * x1.varValue + 0.08 * x2.varValue)
    else:
        print("The model is infeasible")

solve_investment_problem()
