
import gurobipy as gp

# Create a new model
m = gp.Model("cleaning_optimization")

# Create variables
houses = m.addVar(vtype=gp.GRB.CONTINUOUS, name="houses")
apartments = m.addVar(vtype=gp.GRB.CONTINUOUS, name="apartments")


# Set objective function
m.setObjective(300 * houses + 250 * apartments, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * houses + apartments <= 600, "sweeping_constraint")
m.addConstr(2 * houses + 1.5 * apartments <= 700, "mopping_constraint")
m.addConstr(houses >= 0, "houses_nonnegative")
m.addConstr(apartments >= 0, "apartments_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of houses to clean: {houses.x}")
    print(f"Number of apartments to clean: {apartments.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

