
from gurobipy import *

# Create a new model
m = Model("Cleaning_Company")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="houses_cleaned")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="apartments_cleaned")

# Set the objective function
m.setObjective(300*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + x2 <= 600, "sweeping_hours")
m.addConstr(2*x1 + 1.5*x2 <= 700, "mopping_hours")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Houses cleaned: {x1.x}")
    print(f"Apartments cleaned: {x2.x}")
    print(f"Maximum profit: ${300*x1.x + 250*x2.x:.2f}")
else:
    print("No optimal solution found")
