
import gurobipy as gp

# Create a new model
model = gp.Model("Cleaning_Company_Optimization")

# Define the variables
x1 = model.addVar(name="houses", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="apartments", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(300*x1 + 250*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x1 + x2 <= 600, name="sweeping_hours")
model.addConstr(2*x1 + 1.5*x2 <= 700, name="mopping_hours")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: houses = {x1.varValue}, apartments = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
