
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture_Production")

# Create variables
dining_tables = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dining_tables")  # Number of dining tables
coffee_tables = model.addVar(vtype=gp.GRB.CONTINUOUS, name="coffee_tables")  # Number of coffee tables


# Set objective function
model.setObjective(200 * dining_tables + 100 * coffee_tables, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(250 * dining_tables + 150 * coffee_tables <= 20000, "budget_constraint")
model.addConstr(dining_tables + coffee_tables <= 200, "demand_constraint")
model.addConstr(dining_tables >= 0, "non_negativity_dining")
model.addConstr(coffee_tables >= 0, "non_negativity_coffee")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of dining tables: {dining_tables.x}")
    print(f"Number of coffee tables: {coffee_tables.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

