
from gurobipy import *

# Create a new model
m = Model("Furniture_Problem")

# Define variables
x1 = m.addVar(name='x1', lb=0)  # Number of dining tables
x2 = m.addVar(name='x2', lb=0)  # Number of coffee tables

# Set the objective function: Maximize profit
m.setObjective(200*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200, name='total_tables')
m.addConstr(250*x1 + 150*x2 <= 20000, name='budget')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of dining tables: {x1.x}")
    print(f"Number of coffee tables: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 100*x2.x:.2f}")
else:
    print("No optimal solution found.")
