
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="dining_tables", lb=0, ub=gurobi.GRB.INFINITY, obj=150)
    x2 = model.addVar(name="coffee_tables", lb=0, ub=gurobi.GRB.INFINITY, obj=50)

    # Add constraints
    model.addConstr(x1 + x2 <= 200, name="demand_constraint")
    model.addConstr(250*x1 + 150*x2 <= 20000, name="budget_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Dining tables: {x1.x}")
        print(f"Coffee tables: {x2.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
