
import gurobipy as gp

# Create a new model
m = gp.Model("bolts_and_nuts")

# Create variables
scooters = m.addVar(vtype=gp.GRB.CONTINUOUS, name="scooters")  # x1
bikes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bikes")  # x2


# Set objective function
m.setObjective(100 * scooters + 50 * bikes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * scooters + 4 * bikes <= 10, "grinder_constraint")
m.addConstr(3 * scooters + 3 * bikes <= 10, "polisher_constraint")
m.addConstr(scooters >= 0, "scooters_non_negative")  # Ensure non-negative production
m.addConstr(bikes >= 0, "bikes_non_negative")  # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of scooters to produce: {scooters.x}")
    print(f"Number of bikes to produce: {bikes.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

