
from gurobipy import *

# Create a new model
m = Model("Bolts_and_Nuts")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="scooters", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bikes", lb=0)

# Set the objective function
m.setObjective(100*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 <= 10, "grinder")
m.addConstr(3*x1 + 3*x2 <= 10, "polisher")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of scooters: {x1.x}")
    print(f"Number of bikes: {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
