
import gurobipy as gp

# Create a new model
model = gp.Model("Scooters_and_Bikes")

# Define variables
x1 = model.addVar(name="scooters", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="bikes", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: maximize profit
model.setObjective(100*x1 + 50*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*x1 + 4*x2 <= 10, name="grinder_constraint")
model.addConstr(3*x1 + 3*x2 <= 10, name="polisher_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.getVarByName('scooters').varName} = {model.getVarByName('scooters').x}, {model.getVarByName('bikes').varName} = {model.getVarByName('bikes').x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
