
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tomato_paste")

# Create variables
cherry = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry")
cocktail = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cocktail")


# Set objective function
m.setObjective(3 * cherry + 4 * cocktail, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * cherry + 2.5 * cocktail >= 350, "sugar")
m.addConstr(1.5 * cherry + 3 * cocktail >= 250, "acid")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {m.objVal}")
    print(f"Cherry tomatoes: {cherry.x}")
    print(f"Cocktail tomatoes: {cocktail.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

