
from gurobipy import *

# Create a new model
m = Model("Tomato_Paste_Optimization")

# Define the variables
x1 = m.addVar(lb=0, name="cherry_tomatoes")
x2 = m.addVar(lb=0, name="cocktail_tomatoes")

# Set the objective function
m.setObjective(3*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 2.5*x2 >= 350, "sugar_constraint")
m.addConstr(1.5*x1 + 3*x2 >= 250, "acid_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cherry tomatoes: {x1.x}")
    print(f"Cocktail tomatoes: {x2.x}")
    print(f"Minimum cost: {m.objVal}")
else:
    print("No optimal solution found")
