
import gurobi

def solve_tomato_paste_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cherry_tomatoes", lb=0)
    x2 = model.addVar(name="cocktail_tomatoes", lb=0)

    # Define the objective function
    model.setObjective(3*x1 + 4*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(5*x1 + 2.5*x2 >= 350, name="sugar_constraint")
    model.addConstr(1.5*x1 + 3*x2 >= 250, name="acid_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: {model.objVal}")
        print(f"Units of cherry tomatoes: {x1.x}")
        print(f"Units of cocktail tomatoes: {x2.x}")
    else:
        print("The model is infeasible")

solve_tomato_paste_problem()
