
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wine_production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # Regular wine bottles
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # Premium wine bottles

# Set objective function
m.setObjective(20*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 80, "demand_regular")
m.addConstr(x2 <= 50, "demand_premium")
m.addConstr(x1 + x2 <= 120, "total_production")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Regular wine bottles: {x1.x:.2f}")
    print(f"Premium wine bottles: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

