
from gurobipy import *

# Create a new model
model = Model("Wine_Production")

# Add variables
x1 = model.addVar(lb=0, name="regular_wine")
x2 = model.addVar(lb=0, name="premium_wine")

# Set the objective function
model.setObjective(20*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 80, name="demand_regular")
model.addConstr(x2 <= 50, name="demand_premium")
model.addConstr(x1 + x2 <= 120, name="total_supply")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal production levels:")
    print(f"Regular wine: {x1.x} bottles")
    print(f"Premium wine: {x2.x} bottles")
    print(f"Total profit: ${20*x1.x + 50*x2.x}")
else:
    print("No optimal solution found.")
