
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="regular_wine")
x2 = model.addVar(lb=0, name="premium_wine")

# Set the objective function
model.setObjective(20*x1 + 50*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 80, name="demand_regular")
model.addConstr(x2 <= 50, name="demand_premium")
model.addConstr(x1 + x2 <= 120, name="supply")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bottles of regular wine per day: {x1.varValue}")
    print(f"Bottles of premium wine per day: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
