
import gurobipy as gp

# Create a new model
m = gp.Model("costume_optimization")

# Create variables
policeman_costumes = m.addVar(vtype=gp.GRB.INTEGER, name="policeman_costumes")
fireman_costumes = m.addVar(vtype=gp.GRB.INTEGER, name="fireman_costumes")

# Set objective function
m.setObjective(8 * policeman_costumes + 10 * fireman_costumes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * policeman_costumes + 15 * fireman_costumes <= 3000, "budget_constraint")
m.addConstr(policeman_costumes + fireman_costumes <= 280, "demand_constraint")
m.addConstr(policeman_costumes >= 0, "policeman_nonnegative")
m.addConstr(fireman_costumes >= 0, "fireman_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of policeman costumes: {policeman_costumes.x}")
    print(f"Number of fireman costumes: {fireman_costumes.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

