
from gurobipy import *

# Create a new model
m = Model("Costume_Store_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="policeman_costumes")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="fireman_costumes")

# Set the objective function
m.setObjective(8*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 3000, "Budget_Constraint")
m.addConstr(x1 + x2 <= 280, "Demand_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
