
import gurobi

def solve_costume_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="Policeman_Costumes")
    x2 = model.addVar(lb=0, name="Fireman_Costumes")

    # Define the objective function
    model.setObjective(8*x1 + 10*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x1 + 15*x2 <= 3000, name="Budget_Constraint")
    model.addConstr(x1 + x2 <= 280, name="Demand_Constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Policeman costumes: {x1.varValue}")
        print(f"Fireman costumes: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_costume_problem()
