
import gurobipy as gp

# Create a new model
model = gp.Model("Ball_Production")

# Create variables
soccer_balls = model.addVar(vtype=gp.GRB.CONTINUOUS, name="soccer_balls")
basketballs = model.addVar(vtype=gp.GRB.CONTINUOUS, name="basketballs")


# Set objective function
model.setObjective(4 * soccer_balls + 5 * basketballs, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * soccer_balls + 7 * basketballs <= 700, "manufacturing_time")
model.addConstr(3 * soccer_balls + 4 * basketballs <= 500, "filling_time")
model.addConstr(soccer_balls >= 0, "soccer_balls_nonnegative")  # Ensure non-negative production
model.addConstr(basketballs >= 0, "basketballs_nonnegative") # Ensure non-negative production


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Soccer Balls: {soccer_balls.x}")
    print(f"Number of Basketballs: {basketballs.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

