
from gurobipy import *

# Create a model
m = Model("Soccer_and_Basketball_Production")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="soccer_balls", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="basketballs", lb=0)

# Set the objective function
m.setObjective(4*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 7*x2 <= 700, "machine_time")
m.addConstr(3*x1 + 4*x2 <= 500, "air_filling")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
